/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter.matchers;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import me.desht.modularrouters.client.util.IHasTranslationKey;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidUtil;

public class InspectionMatcher
implements IItemMatcher {
    private final ComparisonList comparisonList;

    public InspectionMatcher(ComparisonList comparisons) {
        this.comparisonList = comparisons;
    }

    @Override
    public boolean matchItem(ItemStack stack, Filter.Flags flags) {
        int matched = 0;
        if (this.comparisonList.items.isEmpty()) {
            return false;
        }
        for (Comparison comp : this.comparisonList.items) {
            if (!comp.test(stack)) continue;
            if (!this.comparisonList.matchAll) {
                return true;
            }
            ++matched;
        }
        return matched >= this.comparisonList.items.size();
    }

    public static class ComparisonList {
        public final List<Comparison> items;
        boolean matchAll;

        public ComparisonList(List<Comparison> items, boolean matchAll) {
            this.items = items;
            this.matchAll = matchAll;
        }

        public void setMatchAll(boolean matchAll) {
            this.matchAll = matchAll;
        }

        public boolean isMatchAll() {
            return this.matchAll;
        }
    }

    public static class Comparison
    implements Predicate<ItemStack> {
        static final Comparison BAD_COMPARISON = new Comparison();
        private final InspectionSubject subject;
        private final InspectionOp op;
        private final long target;

        Comparison(InspectionSubject subject, InspectionOp op, int target) {
            this.subject = subject;
            this.op = op;
            this.target = target;
        }

        Comparison() {
            this.subject = null;
            this.op = null;
            this.target = 0L;
        }

        @Override
        public boolean test(ItemStack stack) {
            if (this.op == null || this.subject == null) {
                return false;
            }
            Optional<Integer> val = this.subject.evaluator.apply(stack);
            return this.op.test((long)val.orElse(-1), this.target);
        }

        public static Comparison fromString(String s) {
            String[] fields = s.split(" ", 3);
            if (fields.length != 3) {
                return BAD_COMPARISON;
            }
            try {
                InspectionSubject subject = InspectionSubject.valueOf(fields[0]);
                InspectionOp op = InspectionOp.valueOf(fields[1]);
                int target = Integer.parseInt(fields[2]);
                return new Comparison(subject, op, target);
            }
            catch (IllegalArgumentException e) {
                return BAD_COMPARISON;
            }
        }

        public String toString() {
            return Joiner.on((String)" ").join((Object)this.subject, (Object)this.op, new Object[]{this.target});
        }

        public Component asLocalizedText() {
            if (this.subject == null || this.op == null) {
                return new TextComponent("<?>");
            }
            return new TextComponent(" ").m_7220_((Component)new TranslatableComponent("modularrouters.guiText.label.inspectionSubject." + this.subject)).m_130946_(" ").m_7220_((Component)new TranslatableComponent("modularrouters.guiText.label.inspectionOp." + this.op)).m_130946_(this.target + this.subject.suffix);
        }
    }

    public static enum InspectionOp implements IHasTranslationKey,
    BiPredicate<Long, Long>
    {
        NONE((val, target) -> false),
        GT((val, target) -> val > target),
        LT((val, target) -> val < target),
        LE((val, target) -> val <= target),
        GE((val, target) -> val >= target),
        EQ(Objects::equals),
        NE((val, target) -> !Objects.equals(val, target));

        private final BiPredicate<Long, Long> predicate;

        private InspectionOp(BiPredicate<Long, Long> predicate) {
            this.predicate = predicate;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.inspectionOp." + this;
        }

        @Override
        public boolean test(Long value, Long target) {
            return this.predicate.test(value, target);
        }

        public InspectionOp cycle(int direction) {
            int n = this.ordinal() + direction;
            if (n >= InspectionOp.values().length) {
                n = 0;
            } else if (n < 0) {
                n = InspectionOp.values().length - 1;
            }
            return InspectionOp.values()[n];
        }
    }

    public static enum InspectionSubject implements IHasTranslationKey
    {
        NONE("", stack -> Optional.empty()),
        DURABILITY("%", InspectionSubject::getDurabilityPercent),
        FLUID("%", InspectionSubject::getFluidPercent),
        ENERGY("%", InspectionSubject::getEnergyPercent),
        ENCHANT("", InspectionSubject::getHighestEnchantLevel),
        FOOD("", InspectionSubject::getFoodValue);

        private final String suffix;
        private final Function<ItemStack, Optional<Integer>> evaluator;
        private static final BigDecimal HUNDRED;

        private InspectionSubject(String suffix, Function<ItemStack, Optional<Integer>> evaluator) {
            this.suffix = suffix;
            this.evaluator = evaluator;
        }

        @Override
        public String getTranslationKey() {
            return "modularrouters.guiText.label.inspectionSubject." + this;
        }

        private static Optional<Integer> getDurabilityPercent(ItemStack stack) {
            return stack.m_41776_() > 0 ? Optional.of(InspectionSubject.asPercentage(stack.m_41776_() - stack.m_41773_(), stack.m_41776_())) : Optional.empty();
        }

        private static Optional<Integer> getFoodValue(ItemStack stack) {
            return stack.m_41720_().m_41472_() ? Optional.of(stack.m_41720_().m_41473_().m_38744_()) : Optional.empty();
        }

        private static Optional<Integer> getHighestEnchantLevel(ItemStack stack) {
            return EnchantmentHelper.m_44831_((ItemStack)stack).values().stream().max(Comparator.naturalOrder());
        }

        private static Optional<Integer> getEnergyPercent(ItemStack stack) {
            return stack.getCapability(CapabilityEnergy.ENERGY, null).map(handler -> Optional.of(InspectionSubject.asPercentage(handler.getEnergyStored(), handler.getMaxEnergyStored()))).orElse(Optional.empty());
        }

        private static Optional<Integer> getFluidPercent(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
                int total = 0;
                int max = 0;
                for (int idx = 0; idx < handler.getTanks(); ++idx) {
                    max += handler.getTankCapacity(idx);
                    total += handler.getFluidInTank(idx).getAmount();
                }
                return Optional.of(InspectionSubject.asPercentage(total, max));
            }).orElse(Optional.empty());
        }

        public InspectionSubject cycle(int direction) {
            int n = this.ordinal() + direction;
            if (n >= InspectionSubject.values().length) {
                n = 0;
            } else if (n < 0) {
                n = InspectionSubject.values().length - 1;
            }
            return InspectionSubject.values()[n];
        }

        private static int asPercentage(long val, long max) {
            if (max == 0L) {
                return 0;
            }
            BigDecimal a = new BigDecimal(val);
            BigDecimal b = new BigDecimal(max);
            return a.multiply(HUNDRED).divide(b, RoundingMode.DOWN).intValue();
        }

        static {
            HUNDRED = new BigDecimal(100);
        }
    }
}

